
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
};

struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float3 normal		: TEXCOORD0;
	float4 colour		: COLOR0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_glowhighlighter( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	output.normal = normalize(mul(input.normal, (float3x3)shader_transform_world));
		
	float3 vCamera = normalize(output.position-shader_camera_eyePosition);
	float3 vHalfway = normalize(-shader_light_direction - vCamera);
	
	if (dot( output.normal, -vCamera ) < 0.0)
		output.normal *= -1.0;

	output.colour = shader_geometry_colour.a * shader_material_specular.r * shader_light_specular.r * saturate(pow(dot( output.normal, vHalfway ), (1.0 / shader_material_eccentricity)*5));

	output.position = mul(output.position, shader_transform_viewProj);

	return output;
}


float4 ps_glowhighlighter( VS_OUTPUT_HIGH input ) : COLOR0
{
	return float4(clamp(input.colour,0,1).rgb,1);
}



////////////////////////////////////////////////////////////

technique tech_glowhighlighter_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_glowhighlighter();	
		PixelShader = compile ps_2_0 ps_glowhighlighter();	
	}
}